/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import ext.base.core.BcStringUtil;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.swg.SwgFocusTraversalPolicy;
import ext.lib.swg.SwgInputContextHelper;
import ext.lib.swg.SwgMenuItem;
import ext.lib.swg.lookAndFeel.SwgLafManager;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class SwgTextArea
extends JTextArea
implements Serializable {
    private static final long serialVersionUID = -2498788462483431348L;
    protected SwgInputContextHelper inputContextHelper;
    protected Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    protected boolean isLostFocus;
    protected JPopupMenu popupMenu = new JPopupMenu();
    protected SwgMenuItem cutMenu;
    protected SwgMenuItem copyMenu;
    protected SwgMenuItem pastMenu;
    protected SwgMenuItem deleteMenu;
    protected SwgMenuItem selectAllMenu;
    protected SwgMenuItem unicodeMenu;
    protected boolean isSelectAllAtFocusGaind = true;
    protected ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            SwgTextArea.this.actionPerformed1(ev);
        }
    };
    protected KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent ev) {
            SwgTextArea.this.keyEvent(ev);
        }

        @Override
        public void keyReleased(KeyEvent ev) {
            SwgTextArea.this.keyEvent(ev);
        }

        @Override
        public void keyTyped(KeyEvent ev) {
            SwgTextArea.this.keyEvent(ev);
        }
    };
    protected MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent ev) {
            SwgTextArea.this.mouseEvent(ev);
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            SwgTextArea.this.mouseEvent(ev);
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            SwgTextArea.this.mouseEvent(ev);
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            SwgTextArea.this.mouseEvent(ev);
        }
    };
    protected FocusListener focusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent ev) {
            SwgTextArea.this.focusEvent(ev);
        }

        @Override
        public void focusLost(FocusEvent ev) {
            SwgTextArea.this.focusEvent(ev);
        }
    };
    protected InputMethodListener inputMethodListener = new InputMethodListener(){

        @Override
        public void inputMethodTextChanged(InputMethodEvent ev) {
            if (SwgTextArea.this.isLostFocus) {
                ev.consume();
                SwgTextArea.this.isLostFocus = false;
            }
        }

        @Override
        public void caretPositionChanged(InputMethodEvent event) {
        }
    };

    static {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        FocusTraversalPolicy focusTraversalPolicy = keyboardFocusManager.getDefaultFocusTraversalPolicy();
        if (!SwgFocusTraversalPolicy.class.isAssignableFrom(focusTraversalPolicy.getClass())) {
            SwgFocusTraversalPolicy lbFocusTraversalPolicy = new SwgFocusTraversalPolicy();
            keyboardFocusManager.setDefaultFocusTraversalPolicy(lbFocusTraversalPolicy);
        }
    }

    public SwgTextArea() throws Exception {
        this.init();
    }

    public SwgTextArea(String text) throws Exception {
        this.init();
        this.setText(text);
    }

    protected void init() throws Exception {
        this.inputContextHelper = new SwgInputContextHelper(this);
        this.addKeyListener(this.keyListener);
        this.addMouseListener(this.mouseListener);
        this.addFocusListener(this.focusListener);
        this.cutMenu = new SwgMenuItem(BcWords.getInstance().cut, new ImageIcon(AwtImageHelper.getImage_icon("cut_64x64.png")));
        this.cutMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.cutMenu);
        this.copyMenu = new SwgMenuItem(BcWords.getInstance().copy, new ImageIcon(AwtImageHelper.getImage_icon("copy_64x64.png")));
        this.copyMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.copyMenu);
        this.pastMenu = new SwgMenuItem(BcWords.getInstance().past, new ImageIcon(AwtImageHelper.getImage_icon("paste_64x64.png")));
        this.pastMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.pastMenu);
        this.deleteMenu = new SwgMenuItem(BcWords.getInstance().delete, new ImageIcon(AwtImageHelper.getImage_icon("cancel_64x64.png")));
        this.deleteMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.deleteMenu);
        this.popupMenu.addSeparator();
        this.selectAllMenu = new SwgMenuItem(BcWords.getInstance().selectAll);
        this.selectAllMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.selectAllMenu);
        this.popupMenu.addSeparator();
        this.unicodeMenu = new SwgMenuItem("Unicode\u8868\u793a");
        this.unicodeMenu.addActionListener(this.actionListener);
        this.popupMenu.add(this.unicodeMenu);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (editable) {
            this.setBackground(SwgLafManager.getInstance().textField_EditablBg);
        } else {
            this.setBackground(SwgLafManager.getInstance().textField_NotEditablBg);
        }
    }

    @Override
    public void setText(String text) {
        if (BcStringUtil.isEmpty(text)) {
            super.setText("");
        } else {
            super.setText(text);
        }
    }

    protected void actionPerformed1(ActionEvent ev) {
        try {
            this.actionPerformed2(ev);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), BcWords.getInstance().exception, 0);
        }
    }

    protected void actionPerformed2(ActionEvent ev) throws Exception {
        if (ev.getSource() == this.cutMenu) {
            if (this.isEditable()) {
                this.cut();
            }
        } else if (ev.getSource() == this.copyMenu) {
            this.copy();
        } else if (ev.getSource() == this.pastMenu) {
            if (this.isEditable()) {
                this.paste();
            }
        } else if (ev.getSource() == this.deleteMenu) {
            if (this.isEditable()) {
                this.replaceSelection(null);
            }
        } else if (ev.getSource() == this.selectAllMenu) {
            super.selectAll();
        } else if (ev.getSource() == this.unicodeMenu) {
            StringBuilder sb = BcStringUtil.toCharCode(this.getText());
            JOptionPane.showMessageDialog(this, sb.toString(), "Unicode", 1);
        }
    }

    protected void keyEvent(KeyEvent ev) {
        switch (ev.getID()) {
            case 401: {
                switch (ev.getKeyCode()) {
                    case 10: {
                        this.transferFocus();
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 17: {
                        break;
                    }
                    case 65489: {
                        if (!this.isEditable()) break;
                        this.cut();
                        break;
                    }
                    case 65485: {
                        this.copy();
                        break;
                    }
                    case 65487: {
                        if (!this.isEditable()) break;
                        this.paste();
                        break;
                    }
                    case 127: {
                        if (!this.isEditable()) break;
                        super.replaceSelection(null);
                    }
                }
                break;
            }
            case 402: {
                break;
            }
        }
    }

    protected void mouseEvent(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.setPopupMenuAttribute();
            this.popupMenu.show(this, ev.getX(), ev.getY());
            return;
        }
        switch (ev.getID()) {
            case 504: {
                break;
            }
            case 505: {
                break;
            }
            case 503: {
                break;
            }
            case 501: {
                break;
            }
            case 506: {
                break;
            }
            case 502: {
                break;
            }
        }
    }

    protected void focusEvent(FocusEvent ev) {
        switch (ev.getID()) {
            case 1004: {
                if (this.isEnabled() && this.isEditable() && this.isSelectAllAtFocusGaind) {
                    this.selectAll();
                }
                this.inputContextHelper.focusEvent(ev);
                break;
            }
            case 1005: {
                this.isLostFocus = true;
                this.inputContextHelper.focusEvent(ev);
            }
        }
    }

    public void setPopupMenuAttribute() {
        Transferable transferable = this.clipboard.getContents(this);
        String clipText = null;
        if (transferable != null) {
            try {
                clipText = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cutMenu.setEnabled(this.isEnabled() && this.isEditable() && this.getSelectionEnd() - this.getSelectionStart() > 0);
        this.copyMenu.setEnabled(this.getSelectionEnd() - this.getSelectionStart() > 0);
        this.selectAllMenu.setEnabled(this.getText().length() > 0);
        this.pastMenu.setEnabled(this.isEnabled() && this.isEditable() && clipText != null);
        this.deleteMenu.setEnabled(this.isEnabled() && this.isEditable() && this.getSelectionEnd() - this.getSelectionStart() > 0);
    }

    protected void setSelectAllAtFocusGaindValid(boolean isSelectAllAtFocusGaind) {
        this.isSelectAllAtFocusGaind = isSelectAllAtFocusGaind;
    }
}

